/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.trinkets;

import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.client.model.BipedJsonModel;
import xzeroair.trinkets.items.base.AccessoryBase;
import xzeroair.trinkets.traits.abilities.AbilityEnderQueen;
import xzeroair.trinkets.traits.abilities.compat.survival.AbilityColdImmunity;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ClientConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigEnderCrown;
import xzeroair.trinkets.util.helpers.TranslationHelper;

public class TrinketEnderTiara
extends AccessoryBase {
    public static final ConfigEnderCrown serverConfig = TrinketsConfig.SERVER.Items.ENDER_CROWN;
    public static final ClientConfig.ClientConfigItems.ClientConfigEnderCrown clientConfig = TrinketsConfig.CLIENT.items.ENDER_CROWN;
    private BipedJsonModel tiara;

    public TrinketEnderTiara(String name) {
        super(name);
        this.setUUID("a45dbc1c-17e9-40b4-b6a3-09dea74355b7");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected String customItemInformation(ItemStack stack, World world, ITooltipFlag flagIn, int index, String translation) {
        TranslationHelper helper = TranslationHelper.INSTANCE;
        TranslationHelper.LangEntry key = new TranslationHelper.LangEntry(this.func_77667_c(stack), "damageignored", TrinketEnderTiara.serverConfig.dmgChance);
        TranslationHelper.LangEntry key1 = new TranslationHelper.LangEntry(this.func_77667_c(stack), "endermenchance", TrinketEnderTiara.serverConfig.spawnChance);
        TranslationHelper.LangEntry key2 = new TranslationHelper.LangEntry(this.func_77667_c(stack), "endermenfollow", TrinketEnderTiara.serverConfig.Follow);
        TranslationHelper.LangEntry key3 = new TranslationHelper.LangEntry(this.func_77667_c(stack), "waterhurts", TrinketEnderTiara.serverConfig.water_hurts);
        TranslationHelper.OptionEntry key4 = new TranslationHelper.OptionEntry("chance", TrinketEnderTiara.serverConfig.dmgChance || TrinketEnderTiara.serverConfig.spawnChance, MathHelper.func_76131_a((float)(1.0f / (float)TrinketEnderTiara.serverConfig.chance * 100.0f), (float)-2.1474836E9f, (float)2.1474836E9f) + "%");
        boolean tan = Trinkets.ToughAsNails && TrinketsConfig.compat.toughasnails || Trinkets.SimpleDifficulty && TrinketsConfig.compat.simpledifficulty;
        TranslationHelper.LangEntry TAN = new TranslationHelper.LangEntry(this.func_77667_c(stack), "coldimmune", tan && TrinketEnderTiara.serverConfig.compat.tan.immuneToCold);
        return helper.formatAddVariables(translation, key, key1, key2, key3, key4, TAN);
    }

    @Override
    public String[] getAttributeConfig() {
        return TrinketEnderTiara.serverConfig.attributes;
    }

    @Override
    public void initAbilities(ItemStack stack, EntityLivingBase entity, List<IAbilityInterface> abilities) {
        boolean tan;
        abilities.add(new AbilityEnderQueen());
        boolean bl = tan = Trinkets.ToughAsNails && TrinketsConfig.compat.toughasnails || Trinkets.SimpleDifficulty && TrinketsConfig.compat.simpledifficulty;
        if (tan && TrinketEnderTiara.serverConfig.compat.tan.immuneToCold) {
            abilities.add(new AbilityColdImmunity());
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return super.getAttributeModifiers(slot, stack);
    }

    public EntityEquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EntityEquipmentSlot.HEAD;
    }

    @Override
    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        boolean alreadyEquipped = entity instanceof EntityLivingBase && TrinketHelper.AccessoryCheck((EntityLivingBase)entity, this);
        return !alreadyEquipped && super.isValidArmor(stack, armorType, entity);
    }

    @Override
    public boolean canEquipAccessory(ItemStack stack, EntityLivingBase player) {
        boolean alreadyEquipped = false;
        try {
            alreadyEquipped = TrinketHelper.getSlotInfoForItemFromEquipment(player, s -> s != null && !s.func_190926_b() && s.func_77969_a(stack)) == null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return alreadyEquipped && super.canEquipAccessory(stack, player);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (!itemStack.func_190926_b()) {
            BipedJsonModel model = this.tiara;
            model.tranformType = ItemCameraTransforms.TransformType.HEAD;
            model.equippedAsAccessory = false;
            model.func_178686_a((ModelBase)_default);
            model.field_78117_n = _default.field_78117_n;
            model.field_78093_q = _default.field_78093_q;
            model.field_78091_s = _default.field_78091_s;
            model.field_187076_m = _default.field_187076_m;
            model.field_187075_l = _default.field_187075_l;
            return model;
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playerRenderLayer(ItemStack stack, EntityLivingBase player, RenderPlayer renderer, boolean isSlim, float partialTicks, float scale) {
        if (!TrinketEnderTiara.clientConfig.doRender) {
            return;
        }
        if (this.tiara == null) {
            this.tiara = new BipedJsonModel(new ResourceLocation(this.getRegistryName().toString() + "_model"));
        }
        GlStateManager.func_179094_E();
        BipedJsonModel model = this.tiara;
        model.equippedAsAccessory = true;
        model.tranformType = ItemCameraTransforms.TransformType.HEAD;
        double sneakOffset = player.func_70093_af() ? 0.2 : 0.0;
        boolean hasHelmet = player.func_190630_a(EntityEquipmentSlot.HEAD);
        float hScale = hasHelmet ? 1.2f : 1.0f;
        double helmetOffsetY = hasHelmet ? 0.12 : 0.0;
        double helmetOffsetZ = hasHelmet ? -0.04 : 0.0;
        GlStateManager.func_179137_b((double)0.0, (double)sneakOffset, (double)0.0);
        renderer.func_177087_b().field_78116_c.func_78794_c(scale);
        GlStateManager.func_179137_b((double)0.0, (double)0.19, (double)-0.04);
        GlStateManager.func_179152_a((float)(scale * 10.0f), (float)(scale * 10.0f), (float)(scale * 10.0f));
        GlStateManager.func_179137_b((double)0.0, (double)helmetOffsetY, (double)helmetOffsetZ);
        GlStateManager.func_179152_a((float)hScale, (float)hScale, (float)hScale);
        model.func_78088_a((Entity)player, player.field_184619_aG, player.field_70721_aZ, player.field_70173_aa, player.field_70177_z, player.field_70125_A, scale);
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean ItemEnabled() {
        return TrinketEnderTiara.serverConfig.enabled;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelResourceLocation normal = new ModelResourceLocation(this.getRegistryName().toString(), "inventory");
        ModelResourceLocation model = new ModelResourceLocation(this.getRegistryName().toString() + "_model", "inventory");
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{normal, model});
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> Capabilities.getTrinketProperties(stack, normal, (prop, tex) -> {
            if (prop.getSlotInfo().getHandlerType().equals((Object)TrinketHelper.SlotInformation.ItemHandlerType.HEAD)) {
                return model;
            }
            return tex;
        }));
    }
}

